<title>Deposit List - Best Leearning</title>
@extends('user.layouts.master')
@section('css')
    <link rel="stylesheet" href="https://www.powerworkerearn.com/css?family=Open+Sans:300,400,600,700">
    <link rel="stylesheet" href="https://www.powerworkerearn.com/resources/css/argon.css" type="text/css">
    <link rel="stylesheet" href="https://www.powerworkerearn.com/resources/css/myapp.css" type="text/css">

@endsection
@section('user-content')
<div class="row justify-content-center">
    <div class="col-xl-6">
        <div class="card mt-2">
            <div class="card-header">
                <h5 class="h3 mb-0">Deposit History</h5>
            </div>
            <div class="card-body p-0">
                @if ($deposits->isEmpty())
                    <div class="text-center py-3">
                        <p>You Have No Deposit History</p>
                    </div>
                @else
                    <ul class="list-group list-group-flush" data-toggle="checklist">
                        @foreach ($deposits as $key => $data)
                            @if($data->approval == 0)    
                                <li class="checklist-entry list-group-item flex-column align-items-start py-2 px-4">
                                    <div class="checklist-item checklist-item-warning">
                                        <div class="checklist-info">
                                            <h5 class="checklist-title mb-0">{{ $data->phone }} ({{ account_name($data->account_id) }})</h5>
                                            <small>{{ \Carbon\Carbon::parse($data->created_at)->format('j M Y g:i A')}}</small>
                                            <!--<small>(Reviewing...)</small>-->
                                        </div>
                            @elseif($data->approval == 1)
                                <li class="checklist-entry list-group-item flex-column align-items-start py-2 px-4">
                                    <div class="checklist-item checklist-item-success">
                                        <div class="checklist-info">
                                            <h5 class="checklist-title mb-0">{{ $data->phone }} ({{ account_name($data->account_id) }})</h5>
                                            <small>{{ \Carbon\Carbon::parse($data->created_at)->format('j M Y g:i A')}}</small>
                                        </div>
                            @else
                                <li class="checklist-entry list-group-item flex-column align-items-start py-2 px-4">
                                    <div class="checklist-item checklist-item-danger">
                                        <div class="checklist-info">
                                            <h5 class="checklist-title mb-0">{{ $data->phone }} ({{ account_name($data->account_id) }})</h5>
                                            <small>{{ \Carbon\Carbon::parse($data->created_at)->format('j M Y g:i A')}}</small>
                                            <div class="checklist-info">
                                                <!--<small>Reason: {{ $data->reason }}</small>-->
                                            </div>
                                        </div>
                            @endif
                                        <div>
                                           <h5><b><div style="color:#1D8348";>
                                                <b>{{ $data->amount }} $ </b>
                                            </div></b></h5>
                                        </div>
                                    </div>
                                </li>
                        @endforeach
                    </ul>
                @endif
            </div>
        </div>
    </div>
</div>

@endsection
@section('js')
    <script>
        function setAccount(account_id){
            $('#deposit_account').val(account_id);

            $.ajax({
                url: "{{ route('user.deposit-account-info') }}",
                type:"POST",
                data:{
                    _token: '{{csrf_token()}}',
                    account_id: account_id,
                },
                success:function(data) {
                    $('#deposit_area').show();
                    $('#deposit_account_text').html('Account No: '+data['account_no']);
                    $('#deposit_account_guideline').html(data['guideline']);
                },
            });
        }
    </script>
@endsection
